package cn.com.duiba.kjy.api.dto.seller;

import cn.com.duiba.kjy.api.enums.redpacket.SellerPromotionStateEnum;
import cn.com.duiba.kjy.api.enums.redpacket.SellerPromotionTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 销售员优惠表
 * @author kjj mybatis generator
 * 2020-01-07
 */
@Data
public class SellerPromotionDto implements Serializable {
    private static final long serialVersionUID = 15783954208833390L;

    /**
     *主键
     */
    private Long id;

    /**
     *代理人id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     *优惠金额
     */
    private Integer amount;

    /**
     * 类型
     * @see SellerPromotionTypeEnum
     */
    private Integer promotionType;

    /**
     * 状态
     * @see SellerPromotionStateEnum
     */
    private Integer state;

    /**
     *创建时间
     */
    private Date gmtCreate;

    /**
     *更新时间
     */
    private Date gmtModified;
}
