package cn.com.duiba.kjy.api.remoteservice.accurate;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.accurate.SellerAccurateMaterialDto;
import cn.com.duiba.kjy.api.dto.clue.SellerAccurateMaterialExtDto;
import cn.com.duiba.kjy.api.params.accurate.AccurateAggregationPushParam;
import cn.com.duiba.kjy.api.params.accurate.AccurateClueListAllParam;
import cn.com.duiba.kjy.api.params.accurate.AccurateClueListParam;

import java.util.List;
import java.util.Map;

/**
 * 代理人线索信息
 * @author 吴文哲
 * @date 2019-11-07 16:21
 **/
@AdvancedFeignClient
public interface RemoteSellerAccurateMaterialService {

    /**
     * 保存代理人线索详情
     * @param sellerAccurateMaterial
     * @return
     */
    Long save(SellerAccurateMaterialDto sellerAccurateMaterial);

    /**
     * 更新精准素材 有没有用标识
     * @param cluId
     * @param useful
     * @return
     */
    Integer updateAccurateMaterialUseful(Long cluId,Integer useful);

    /**
     * 根据线索Id查找精准线索
     * @param clueId
     * @return
     */
    SellerAccurateMaterialDto findAccurateMaterialById(Long clueId);

    /**
     * 根据scid  visitorId 查询精准线索
     * @param visitorId
     * @param scid
     * @return
     */
    List<SellerAccurateMaterialDto> findByVisitIdAndScid(Long visitorId,Long scid);

    /**
     * 统计总数
     * @param param
     * @return
     */
    Integer countByCondition(AccurateAggregationPushParam param);

    /**
     * 根据访问记录ids查询线索列表
     * @param visitTableIds
     * @return
     */
    List<SellerAccurateMaterialDto> listByVisitTableIds(List<Long> visitTableIds);

    /**
     * 根据访问记录ids 和 线索类型列表 查询线索列表
     * @param visitTableIds 访问记录表id
     * @param type 类型列表
     * @return
     */
    List<SellerAccurateMaterialExtDto> listExtByVisitTableIdsAndTypeIds(List<Long> visitTableIds,List<Integer> type);

    /**
     * 根据访问记录ids返回线索详情列表
     * @param visitTableIds
     * @return
     */
    List<SellerAccurateMaterialExtDto> listExtByVisitTableIds(List<Long> visitTableIds);

    /**
     * 根据销售ids返回最近的一条线索
     * @param sellerIds
     * @return
     */
    List<SellerAccurateMaterialDto> findRecentlyBySellerIds(List<Long> sellerIds);

    /**
     * 根据主键查询线索详情
     * @param id
     * @return
     */
    SellerAccurateMaterialExtDto getExtByClueId(Long id);


    /**
     * 保存代理人线索详情
     * @param extDto
     * @return
     */
    Long saveExtDto(SellerAccurateMaterialExtDto extDto);

    /**
     * 根据主键物理删除
     * @param ids
     * @return
     */
    Integer deleteByIds(List<Long> ids);

    /**
     * 根据主键ID集合获取
     * @param ids 主键ID集合
     * @return 数据
     */
    List<SellerAccurateMaterialDto> listByIds(List<Long> ids);

    /**
     * 根据主键ID集合获取
     * @param ids 主键ID集合
     * @return 数据
     */
    List<SellerAccurateMaterialExtDto> listExtByIds(List<Long> ids);

    /**
     * 根据scid查询线索数
     * @param scidList scid集合
     * @return key:scid value:总数
     */
    Map<Long, Integer> countByScidList(List<Long> scidList);

    /**
     * 通过代理人id查询scid，根据scid的数量倒叙排列进行分页
     * @param param 查询条件
     * @return key:scid value:总数
     */
    Map<Long, Integer> countBySellerId(AccurateAggregationPushParam param);

    /**
     * 根据代理人id查询scid，并根据去重的访问记录表主键id倒叙排列进行分页
     * @param param 查询条件
     * @return key:scid value:去重后的访问记录表主键id的总数
     */
    Map<Long, Integer> countDistinctVisitTableIdBySellerId(AccurateAggregationPushParam param);

    /**
     * 根据代理人id查询并根据scid分组统计总数
     * @param sellerId 代理人id
     * @return 总数
     */
    Integer countDistinctScidBySellerId(Long sellerId);

    /**
     * 根据条件查询有产生过线索的用户id
     * @param sellerId 代理人id
     * @param scid 代理人素材id
     * @param visitIds 访客用户id集合
     * @return 有产生过线索的用户id
     */
    List<Long> findDistinctVisitId(Long sellerId, Long scid, List<Long> visitIds);

    /**
     * 根据代理人素材集合统计去重的访问记录表主键id
     * @param scidList 代理人素材集合
     * @return key：scid，value：去重的访问记录表主键id总数
     */
    Map<Long, Integer> countDistinctVisitTableIdByScids(List<Long> scidList);

    /**
     * 根据条件查询有产生过线索的用户访问记录主键id集合
     * @param sellerId 代理人id
     * @param scid 素材id
     * @param visitTableIds 访问记录主键id
     * @return 有产生过线索的访问记录id
     */
    List<Long> findDistinctVisitTableId(Long sellerId, Long scid, List<Long> visitTableIds);


    /**
     * 根据访问记录id 和 线索类型列表 查询线索列表
     * @param visitTableId 访问记录表id
     * @param type 类型列表
     * @return
     */
    List<SellerAccurateMaterialDto> listExtByVisitTableIdAndTypeIds(Long visitTableId,List<Integer> type);


    /**
     * 线索标记已读
     * @param id
     * @return
     */
    Boolean read(Long id);


    /**
     * 根据代理人ID和线索类型拉取线索列表
     * @param accurateClueListParam
     * @return
     */
    List<SellerAccurateMaterialDto> listCluesByTypesAndSellerId(AccurateClueListParam accurateClueListParam);


    /**
     * 根据代理人ID和线索类型拉取线索Id列表
     * @param accurateClueListAllParam
     * @return
     */
    List<Long> listClueIdsByTypesAndSellerId(AccurateClueListAllParam accurateClueListAllParam);



    /**
     * 根据线索类似查询代理人最近一条未读信息
     * @param sellerId
     * @param readRemark {@link cn.com.duiba.kjy.api.enums.ReadMarkEnum}
     * @param clueTypeList {@link cn.com.duiba.kjy.api.enums.clue.VisitClueTypeEnum}
     * @return
     */
    SellerAccurateMaterialDto lastBySidAndReadAndType(Long sellerId,Integer readRemark,List<Integer> clueTypeList);

    /**
     * 根据代理人线索类型查询客户数
     * @param sellerId
     * @param clueTypeList
     * @return
     */
    int countVisitorBySellerClueType(Long sellerId, List<Integer> clueTypeList);

    /**
     * 根据代理人线索类型查询线索数
     * @param sellerId
     * @param clueTypeList
     * @return
     */
    int countBySellerClueType(Long sellerId, List<Integer> clueTypeList);


    /**
     * 访客是否存在某个线索类型的数据
     * @param visitId
     * @param clueType
     * @return
     */
    Boolean clueExistByVisitIdAndClueType(Long visitId,Integer clueType);
}
