/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.seller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public enum ReadPreferenceTagEnum {
    TAG1("\u65f6\u4e8b\u70ed\u70b9", 0, 5),
    TAG2("\u6b63\u80fd\u91cf", 5, 10),
    TAG3("\u5065\u5eb7\u79d1\u666e", 10, 15),
    TAG4("\u6295\u8d44\u7406\u8d22", 15, 20),
    TAG5("\u8da3\u5473\u4e92\u52a8", 20, 25),
    TAG6("\u80b2\u513f\u4e13\u680f", 25, 30),
    TAG7("\u793e\u4fdd\u5546\u4fdd", 30, 35),
    TAG8("\u517b\u8001\u4fdd\u9669", 35, 40),
    TAG9("\u7406\u8d22\u9669", 40, 45),
    TAG10("\u5065\u5eb7\u9669", 45, 50),
    TAG11("\u5bb6\u5ead\u4fdd\u969c", 50, 55),
    TAG12("\u610f\u5916\u9669", 55, 60),
    TAG13("\u533b\u7597\u9669", 60, 65),
    TAG14("\u91cd\u75be\u9669", 65, 70),
    TAG15("\u5c11\u513f\u9669", 70, 75),
    TAG16("\u8f66\u9669", 75, 80),
    TAG17("\u5bff\u9669", 80, 85),
    TAG18("\u589e\u5458\u610f\u5411", 85, 90),
    TAG19("\u804c\u4e1a\u53d1\u5c55", 90, 95),
    TAG20("\u4fdd\u9669\u610f\u8bc6", 95, 100);

    private String name;
    private Integer startIndex;
    private Integer endIndex;

    private ReadPreferenceTagEnum(String name, Integer startIndex, Integer endIndex) {
        this.name = name;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public static String initData() {
        StringBuilder initData = new StringBuilder();
        for (ReadPreferenceTagEnum readPreferenceTagEnum : ReadPreferenceTagEnum.values()) {
            for (int i = 0; i < readPreferenceTagEnum.getEndIndex() - readPreferenceTagEnum.getStartIndex(); ++i) {
                initData.append("0");
            }
        }
        return initData.toString();
    }

    public static ReadPreferenceTagEnum getByTagIds(String configTag, List<Long> tagIds) {
        JSONObject jsonObject = JSONObject.parseObject((String)configTag);
        for (ReadPreferenceTagEnum readPreferenceTagEnum : ReadPreferenceTagEnum.values()) {
            JSONArray arrayVal = jsonObject.getJSONArray(readPreferenceTagEnum.name());
            if (CollectionUtils.isEmpty((Collection)arrayVal)) continue;
            List longArray = arrayVal.toJavaList(Long.class);
            for (Long tagId : tagIds) {
                if (!longArray.contains(tagId)) continue;
                return readPreferenceTagEnum;
            }
        }
        return null;
    }

    public static String calculateMostReadPreference(String readPreference) {
        int length = readPreference.length();
        long val = 0L;
        String valName = "";
        for (ReadPreferenceTagEnum readPreferenceTagEnum : ReadPreferenceTagEnum.values()) {
            String hexStr;
            Long readPreferenceNum;
            if (readPreferenceTagEnum.getEndIndex() > length || (readPreferenceNum = Long.valueOf(Long.parseLong(hexStr = readPreference.substring(readPreferenceTagEnum.getStartIndex(), readPreferenceTagEnum.getEndIndex()), 16))) <= val) continue;
            val = readPreferenceNum;
            valName = readPreferenceTagEnum.getName();
        }
        return valName;
    }

    public String getName() {
        return this.name;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }
}

