package cn.com.duiba.kjy.api.remoteservice.billing;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.billing.BillingPlanDto;
import cn.com.duiba.kjy.api.dto.billing.BillingPlanTaskDto;

import java.util.List;

/**
 * 60天开单计划服务
 * @author zhanghuifeng
 * date 2020/9/18-13:44
 */
@AdvancedFeignClient
public interface RemoteBillingPlanService {

    /**
     * 初始化代理人60天开单计划
     * @param sellerId
     */
    Boolean initPlan(Long sellerId);

    /**
     * 补卡
     * @param sellerId
     * @return
     */
    Boolean reissueCard(Long sellerId);

    /**
     * 获取代理人未完成任务数
     * @param sellerId
     * @return
     */
    int countSellerUnFinish(Long sellerId);

    /**
     * 根据当天任务查询代理人
     * @param sellerId
     * @param day  例 20200919
     * @return
     */
    List<BillingPlanTaskDto> listBySellerIdAndDay(Long sellerId, Integer day);

    /**
     * 查询代理人是否存在开单计划
     * @param sellerId
     * @return
     */
    boolean existPlanBySellerId(Long sellerId);

    /**
     * 根据当天任务类型查询代理人任务信息
     * @param sellerId
     * @param day
     * @param taskType {@link cn.com.duiba.kjy.api.enums.billing.BillingPlanTaskTypeEnum}
     * @return
     */
    BillingPlanTaskDto findBySellerIdAndDayAndType(Long sellerId, Integer day,Integer taskType);

    /**
     * 完成任务流程
     * @param sellerId
     * @param taskType
     */
    void finishTask(Long sellerId, Integer taskType);

    /**
     * 根据代理人查看
     * @param sellerId
     * @return
     */
    BillingPlanDto findBySellerId(Long sellerId);

    /**
     * 获取代理人未完成任务列表
     * @param sellerId
     * @return
     */
    List<BillingPlanTaskDto> findSellerUnFinish(Long sellerId);

    /**
     * 任务状态表主键ID集合查询
     * @param planStateIds
     * @return
     */
    List<BillingPlanTaskDto> listByPlanStateIds(List<Long> planStateIds);

    /**
     * 失败体验
     * @param sellerId
     * @return
     */
    Boolean failExperience(Long sellerId);

}
