package cn.com.duiba.kjy.api.enums.wx;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2020/10/9 11:34 AM
 */
@Getter
@AllArgsConstructor
public enum WxMenuStatusEnum {

    NON_USE(1, "未启用"),
    ON(2, "已启用"),
    OFF(3, "已下架"),
    ;

    /**
     * 状态
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    private static final Map<Integer, WxMenuStatusEnum> ENUM_MAP = new HashMap<>();

    static {
        for (WxMenuStatusEnum statusEnum : values()) {
            ENUM_MAP.put(statusEnum.getCode(), statusEnum);
        }
    }

    public static WxMenuStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
