package cn.com.duiba.kjy.api.remoteservice.marketing;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.marketing.SellerMarketingGiftConfDto;

/**
 * @author liuchao1
 * @date 2020/2/24 15:39
 */
@AdvancedFeignClient
public interface RemoteSellerMarketingGiftConfService {

    /**
     * 根据id查询
     * @param id 主键id
     * @return 代理人配置的礼物信息
     */
    SellerMarketingGiftConfDto findById(Long id);

    /**
     * 新增代理人礼物信息
     * @param dto 代理人配置的礼物信息
     * @return 主键id
     */
    Long save(SellerMarketingGiftConfDto dto);

    /**
     * 修改
     * @param dto 代理人配置的礼物信息
     * @return 处理是否成功
     */
    boolean update(SellerMarketingGiftConfDto dto);

    /**
     * 根据主键id物理删除
     * @param id 主键id
     * @return 是否删除成功
     */
    boolean delete(Long id);

}
