package cn.com.duiba.kjy.api.dto.crm;

import cn.com.duiba.kjy.api.enums.crm.CrmSellerCustomerProgressTypeEnum;
import cn.com.duiba.kjy.api.enums.crm.CrmSellerCustomerTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 销售CRM客户信息dto
*/
@Data
public class CrmSellerCustomerDto implements Serializable {

    private static final long serialVersionUID = 1986285206443966201L;
    /**
    * 主键
    */
    private Long id;

    /**
    * tb_crm_seller表主键ID
    */
    private Long crmSellerId;

    /**
    * 跟进进度类型:1初步沟通,2评估中,3确认合作,4拉组对接,5确认排期,6首场上线,7完成复盘,8沟通年框,9确认年框	10拒绝合作
     * @see CrmSellerCustomerProgressTypeEnum
    */
    private Integer progressType;

    /**
    * 客户类型，1重点客户,2普通客户
     * @see CrmSellerCustomerTypeEnum
    */
    private Integer customerType;

    /**
    * 备注
    */
    private String remark;

    /**
    * tb_crm_company表主键ID
    */
    private Long crmCompanyId;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

}

