package cn.com.duiba.kjy.api.remoteservice.crm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.crm.CrmCompanyDto;

import java.util.List;

/**
 * 销售CRM 公司remote
 * @author zhanghuifeng
 * date 2020/12/4-09:56
 */
@AdvancedFeignClient
public interface RemoteCrmCompanyService {

    /**
     * 根据公司名称查询公司集合
     * @param companyName
     * @return
     */
    List<CrmCompanyDto> findByCompanyName(String companyName);

    /**
     * 根据crm公司ID集合批量查询
     * @param crmCompanyIds crm公司ID集合
     * @return list
     */
    List<CrmCompanyDto> findByIds(List<Long> crmCompanyIds);
}
