package cn.com.duiba.kjy.api.enums.crm;

import java.util.HashMap;
import java.util.Map;

/**
 * 销售CRM客户跟进进度枚举
 * @author zhanghuifeng
 * date 2020/12/3-17:48
 */
public enum CrmSellerCustomerTypeEnum {

    IMPORTANT(1, "重点客户"),
    NORMAL(2, "普通客户"),

    ;

    private Integer code;
    private String desc;

    CrmSellerCustomerTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, CrmSellerCustomerTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CrmSellerCustomerTypeEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static CrmSellerCustomerTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
