package cn.com.duiba.kjy.api.remoteservice.crm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.crm.CrmSellerCustomerDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.crm.CrmSellerCustomerQryParam;

import java.util.Date;
import java.util.List;

/**
 * 销售CRM客户remote
 * @author zhanghuifeng
 * date 2020/12/3-18:57
 */
@AdvancedFeignClient
public interface RemoteCrmSellerCustomerService {

    /**
     * 分页查询
     * @param param
     * @return
     */
    Page<CrmSellerCustomerDto> pageList(CrmSellerCustomerQryParam param);

    /**
     * 根据代理人查询
     * @param companyIds crm公司ID集合
     * @param crmSellerId crm销售ID(为空时不做查询条件)
     * @return
     */
    List<Long> findCompanyIdsByCompanyAndSeller(List<Long> companyIds,Long crmSellerId);

    /**
     * 查询客户数
     * @param createStart 创建开始时间（包含）
     * @param createEnd 创建结束时间（包含）
     * @param crmSellerId crm销售ID
     * @return
     */
    int countCustomer(Date createStart, Date createEnd, Long crmSellerId);
}
