package cn.com.duiba.kjy.api.dto.crm;

import cn.com.duiba.kjy.api.enums.crm.CrmAbutmentPositionTypeEnum;
import cn.com.duiba.kjy.api.enums.crm.CrmSellerCustomerProgressTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 销售CRM客户信息dto
*/
@Data
public class CrmSellerCustomerDto implements Serializable {

    private static final long serialVersionUID = 1986285206443966201L;
    /**
    * 主键
    */
    private Long id;

    /**
    * tb_crm_seller表主键ID
    */
    private Long crmSellerId;

    /**
    * 跟进进度类型:1初步沟通,2评估中,3确认合作,4PM介入,5确认排期,6首场上线,7完成复盘,8沟通年框,9确认年框	10拒绝合作
     * @see CrmSellerCustomerProgressTypeEnum
    */
    private Integer progressType;

    /**
    * 备注
    */
    private String remark;

    /**
    * tb_crm_company表主键ID
    */
    private Long crmCompanyId;

    /**
     * 对接人名称
     */
    private String abutmentName;

    /**
     * 对接人职位类型，1分公司总经理,2企划总,3培训总,4支公司总经理,5区域总,6机构总,7部经理,8组训,9项目对接人,10其他
     * @see CrmAbutmentPositionTypeEnum
     */
    private Integer abutmentPositionType;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

}

