package cn.com.duiba.kjy.api.remoteservice.crm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.crm.CrmCompanyDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.crm.CrmCompanyAddParam;
import cn.com.duiba.kjy.api.params.crm.CrmCompanyQryParam;

import java.util.List;

/**
 * 销售CRM 公司remote
 * @author zhanghuifeng
 * date 2020/12/4-09:56
 */
@AdvancedFeignClient
public interface RemoteCrmCompanyService {

    /**
     * 根据公司名称查询公司集合
     * @param companyName
     * @return
     */
    List<CrmCompanyDto> findByCompanyName(String companyName);

    /**
     * 根据crm公司ID集合批量查询
     * @param crmCompanyIds crm公司ID集合
     * @return list
     */
    List<CrmCompanyDto> findByIds(List<Long> crmCompanyIds);

    /**
     * 根据公司名称查询公司Id集合
     * @param companyName
     * @return
     */
    List<Long> findIdsByCompanyName(String companyName);

    /**
     * 分页查询
     * @param param
     * @return
     */
    Page<CrmCompanyDto> pageList(CrmCompanyQryParam param);

    /**
     * 新增公司(crm销售创建)
     * @param param
     * @return
     */
    Boolean addFromSeller(CrmCompanyAddParam param);

    /**
     * 根据主键ID查询
     * @param crmCompanyId crm公司ID
     * @return 信息
     */
    CrmCompanyDto findById(Long crmCompanyId);
}
