package cn.com.duiba.kjy.api.dto.crm;

import cn.com.duiba.kjy.api.enums.crm.CrmCompanyCreateTypeEnum;
import cn.com.duiba.kjy.api.enums.crm.CrmCompanyGradeEnum;
import cn.com.duiba.kjy.api.enums.crm.CrmCompanyKjjTypeEnum;
import cn.com.duiba.kjy.api.enums.crm.CrmCompanyTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 销售CRM公司信息Dto
*/
@Data
public class CrmCompanyDto implements Serializable {

    private static final long serialVersionUID = 8367614975327048590L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 客集集类型,1直播公司
     * @see CrmCompanyKjjTypeEnum
    */
    private Integer kjjCompanyType;

    /**
    * 客集集公司ID
    */
    private Long kjjCompanyId;

    /**
    * 公司名称
    */
    private String companyName;

    /**
    * 公司类型，1标准客户,2重点客户
     * @see CrmCompanyTypeEnum
    */
    private Integer companyType;

    /**
    * 公司等级，1总公司,2分公司 3中心支公司
     * @see CrmCompanyGradeEnum
    */
    private Integer companyGrade;

    /**
    * 公司地址
    */
    private String companyAddress;

    /**
    * 创建类型，1后台创建,2销售创建
     * @see CrmCompanyCreateTypeEnum
    */
    private Integer createType;

    /**
     * 上级公司id
     */
    private Long parentCompanyId;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

}

