package cn.com.duiba.kjy.api.params.marketing;

import cn.com.duiba.kjy.api.enums.marketing.MarketingGiftStateEnum;
import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author liuchao1
 * @date 2020/2/22 16:48
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MarketingGiftSearchParam extends PageQuery {

    private static final long serialVersionUID = -3673466180170703197L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 礼物名称
     */
    private String giftName;

    /**
     * 礼物图片
     */
    private String giftPicUrl;

    /**
     * 礼物状态
     * @see MarketingGiftStateEnum
     */
    private Integer giftState;
}
