package cn.com.duiba.kjy.api.remoteservice.crm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.crm.CrmCustomerProgressRecordDto;

import java.util.Date;
import java.util.List;

/**
 * 销售CRM客户更新跟进记录remote
 * @author zhanghuifeng
 * date 2020/12/4-14:41
 */
@AdvancedFeignClient
public interface RemoteCrmCustomerProgressRecordService {

    /**
     * 新增
     * @param dto
     * @return
     */
    Boolean save(CrmCustomerProgressRecordDto dto);

    /**
     * 查询客户数
     * @param createStart 创建开始时间（包含）
     * @param createEnd 创建结束时间（包含）
     * @param crmSellerId crm销售ID
     * @param progressType 进度类型 {@link cn.com.duiba.kjy.api.enums.crm.CrmSellerCustomerProgressTypeEnum}
     * @return
     */
    int countCustomer(Date createStart, Date createEnd, Long crmSellerId, Integer progressType);

    /**
     * 根据公司ID查询跟进记录
     * @param crmCompanyId crm公司ID
     * @return 列表
     */
    List<CrmCustomerProgressRecordDto> findByCompanyId(Long crmCompanyId);
}
