package cn.com.duiba.kjy.api.remoteservice.crm;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.crm.CrmSellerDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.crm.CrmSellerQryParam;

import java.util.List;

/**
 * 销售CRM 销售信息remote
 * @author zhanghuifeng
 * date 2020/12/3-14:02
 */
@AdvancedFeignClient
public interface RemoteCrmSellerService {

    /**
     * 新增
     * @param dto
     * @return
     */
    Boolean save(CrmSellerDto dto);

    /**
     * 更新
     * @param dto
     * @return
     */
    Boolean updateById(CrmSellerDto dto);

    /**
     * 根据主键ID查询
     * @param id 销售ID
     * @return
     */
    CrmSellerDto getById(Long id);

    /**
     * 根据主键ID集合批量查询
     * @param ids 销售ID集合
     * @return
     */
    List<CrmSellerDto> listByIds(List<Long> ids);

    /**
     * 根据ssoId查询
     * @param ssoId
     * @return
     */
    CrmSellerDto findBySsoId(Long ssoId);

    /**
     * 根据销售名称查询列表
     * @param sellerName
     * @return
     */
    List<CrmSellerDto> findByName(String sellerName);

    /**
     * 分页查询
     * @param param
     * @return
     */
    Page<CrmSellerDto> pageList(CrmSellerQryParam param);

    /**
     * 启用/禁用销售
     * @param id
     * @param deleted
     * @return
     */
    Boolean enableSeller(Long id,Integer deleted);

}
