package cn.com.duiba.kjy.api.dto.survey;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 问题选项表
 * @author kjj mybatis generator 
 * 2020-11-24
 */
@Data
public class SurveyQuestionOptionDto implements Serializable {
    private static final long serialVersionUID = 16062078607433889L;

    /**
     * id
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 问题Id
     */
    private Long questionId;

    /**
     * 编码
     */
    private String code;

    /**
     * 显示
     */
    private String title;

    /**
     * 类型，主要用区分其他
     * @see cn.com.duiba.kjy.api.enums.survey.SurveyOptionTypeEnum
     */
    private String type;

    /**
     * 展示其他隐藏的题目
     */
    private String display;

    /**
     * 跳转
     */
    private String jump;

    /**
     * 是否互斥 0：不互斥 1：互斥
     * @see cn.com.duiba.kjy.api.enums.BooleanEnum
     */
    private Integer exclusive;
}