package cn.com.duiba.kjy.api.enums.crm;

import java.util.HashMap;
import java.util.Map;

/**
 * 销售CRM公司类型枚举
 * @author zhanghuifeng
 * date 2020/12/3-17:36
 */
public enum CrmCompanyTypeEnum {

    STANDARD_CUSTOMER(1, "标准客户"),
    IMPORTANT_CUSTOMER(2,"重点客户"),
    ;

    private Integer code;
    private String desc;

    CrmCompanyTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, CrmCompanyTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CrmCompanyTypeEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static CrmCompanyTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
