package cn.com.duiba.kjy.api.enums.wx;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2020/10/16 2:31 下午
 */
@Getter
@AllArgsConstructor
public enum WxTagTypeEnum {

    LIVE_NON_VIP(1, "直播非VIP"),
    LIVE_VIP(2, "直播VIP"),
    LIVE(3, "直播"),
    KJJ(4, "客集集"),
    FAVOURABLE(5, "优惠"),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;

    private static final Map<Integer, WxTagTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (WxTagTypeEnum typeEnum : values()) {
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }

    public static WxTagTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
