package cn.com.duiba.kjy.api.params.greeting;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * 节日贺卡访问记录查询参数
 * @author 刘超
 * @date 2019/12/18 17:31
 * @version 1.0
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class VisitorGreetingCardRecordQueryParam extends PageQuery {

    private static final long serialVersionUID = -899497965612962712L;

    /**
     * 贺卡ID，对应tb_content.id
     */
    private Long contentId;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 用户ID(销售员)，对应 tb_users.id
     */
    private Long sellerUserId;

    /**
     * 活动配置ID，对应tb_seller_greeting_card_conf.id
     */
    private Long confId;

    /**
     * 用户ID(访问者)，对应 tb_users.id
     */
    private Long visitorId;

    /**
     * 是否感谢：0-未答谢，1-答谢
     */
    private Integer thanks;

    /**
     * 开始创建时间（包含）
     */
    private Date startCreateTime;

    /**
     * 结束创建时间（不包含）
     */
    private Date endCreateTime;

    /**
     * 开始领取红包时间（包含）
     */
    private LocalDateTime startReceivedTime;

    /**
     * 结束领取红包时间（不包含）
     */
    private LocalDateTime endReceivedTime;

    /**
     * 领取状态
     * @see cn.com.duiba.kjy.api.enums.greeting.GreetingCardRecordReceiveEnum
     */
    private Integer receivedState;

    /**
     * 是否过滤掉自己
     * 默认不过滤掉
     */
    private boolean ignoreSelf = false;
}
