package cn.com.duiba.kjy.api.params.lottery;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @author lizhi
 * @date 2019/10/23 3:28 PM
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class LotteryOrderParams extends PageQuery {

    private static final long serialVersionUID = 4568152394302527345L;

    /**
     * 活动ID，对应tb_content.id
     */
    private Long activityId;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 活动配置ID，对应tb_seller_activity_conf.id
     */
    private Long activityConfId;

    /**
     * 用户ID(访问者)，对应 tb_users.id
     */
    private Long visitorId;

    /**
     * 开始创建时间（包含）
     */
    private Date startCreateTime;

    /**
     * 结束创建时间（不包含）
     */
    private Date endCreateTime;
}
