package cn.com.duiba.kjy.api.enums.crm;

import java.util.HashMap;
import java.util.Map;

/**
 * 销售CRM公司类型枚举
 * @author zhanghuifeng
 * date 2020/12/3-17:36
 */
public enum CrmCompanyGradeEnum {

    CENTRAL_COMPANY(1, "总公司"),
    BRANCH_COMPANY(2,"分公司"),
    CENTRE_SUBSIDIARY_COMPANY(3,"中心支公司"),
    ;

    private Integer code;
    private String desc;

    CrmCompanyGradeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, CrmCompanyGradeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CrmCompanyGradeEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static CrmCompanyGradeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
