package cn.com.duiba.kjy.api.enums.crm;

import java.util.HashMap;
import java.util.Map;

/**
 * @author linjianhui
 * @description 公司直播状态
 * @date 2020/12/18 11:23
 */
public enum CrmCompanyLiveStateEnum {
    /**
     * 该公司当前直播状态
     */
    LIVE_NONE(1, "暂无直播"),
    LIVE_INIT(2,"进行中"),
    LIVE_END(3,"已结束"),
    ;

    private Integer code;
    private String desc;

    CrmCompanyLiveStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, CrmCompanyLiveStateEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CrmCompanyLiveStateEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static CrmCompanyLiveStateEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
