package cn.com.duiba.kjy.api.remoteservice.crm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.crm.CrmSellerCustomerDto;
import cn.com.duiba.kjy.api.dto.crm.SellerProgressCustomerCountDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.crm.CrmSellerCustomerAddParam;
import cn.com.duiba.kjy.api.params.crm.CrmSellerCustomerQryParam;

import java.util.Date;
import java.util.List;

/**
 * 销售CRM客户remote
 * @author zhanghuifeng
 * date 2020/12/3-18:57
 */
@AdvancedFeignClient
public interface RemoteCrmSellerCustomerService {

    /**
     * 分页查询
     * @param param
     * @return
     */
    Page<CrmSellerCustomerDto> pageList(CrmSellerCustomerQryParam param);

    /**
     * 根据代理人查询
     * @param companyIds crm公司ID集合
     * @param crmSellerId crm销售ID(为空时不做查询条件)
     * @return
     */
    List<Long> findCompanyIdsByCompanyAndSeller(List<Long> companyIds,Long crmSellerId);

    /**
     * 查询客户数
     * @param createStart 创建开始时间（包含）
     * @param createEnd 创建结束时间（包含）
     * @param crmSellerId crm销售ID
     * @return
     */
    int countCustomer(Date createStart, Date createEnd, Long crmSellerId);

    /**
     * 查询各跟进进度累计客户数
     * @param crmSellerId
     * @return
     */
    List<SellerProgressCustomerCountDto> countProgressCustomer(Long crmSellerId);

    /**
     * 获取已经被销售跟进的公司ID集合
     * @param crmCompanyIds crm公司ID集合
     * @return 被销售跟进的公司ID集合
     */
    List<Long> findHasSeller(List<Long> crmCompanyIds);

    /**
     * 根据公司ID查询信息
     * @param crmCompanyId crm公司ID
     * @return
     */
    CrmSellerCustomerDto findByCompanyId(Long crmCompanyId);

    /**
     * 根据crm公司ID更新
     * @param dto
     * @return 结果
     */
    Boolean updateByCompanyId(CrmSellerCustomerDto dto);

    /**
     * 添加客户
     * @param param
     * @return 结果
     */
    Boolean add(CrmSellerCustomerAddParam param);

    /**
     * 根据销售id列表查询
     * @param sellerIds crm销售ID集合
     * @return
     */
    List<CrmSellerCustomerDto> findBySellerIds(List<Long> sellerIds);

    /**
     * 根据公司id列表查询
     * @param companyIds crm公司ID集合
     * @return
     */
    List<CrmSellerCustomerDto> findByCompanyIds(List<Long> companyIds);

    /**
     * 解除公司绑定
     * @param companyId
     * @param sellerId
     * @return
     */
    Boolean deleteBind(Long companyId,Long sellerId);

    /**
     * 更新客户审核状态
     * @param companyId
     * @param verifyState
     * @return
     */
    Boolean updateVerifyStateByCompanyId(Long companyId, Integer verifyState);

}
