package cn.com.duiba.kjy.api.remoteservice.guide;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.strategy.StrategyUsingDto;
import cn.com.duiba.kjy.api.params.guide.StrategyMoveParam;
import cn.com.duiba.kjy.api.params.guide.StrategyParam;
import cn.com.duiba.kjy.api.params.guide.StrategyShowStatusParam;

import java.util.List;

/**
 * 使用攻略管理
 * @Author chentiecheng
 * @Date 2020/6/1 10:58 上午
 */
@AdvancedFeignClient
public interface RemoteStrategyUsingService {

    /**
     * 根据参数查询使用攻略列表
     * @param param
     * @return
     */
    List<StrategyUsingDto> getList(StrategyParam param);

    /**
     * 根据id获取详情
     * @param id
     * @return
     */
    StrategyUsingDto getById(Long id);

    /**
     * 根据参数查询攻略总数
     * @param param
     * @return
     */
    Long count(StrategyParam param);

    /**
     * 新增/编辑使用攻略
     * @param dto
     * @return
     */
    Boolean addOrUpdateStrategy(StrategyUsingDto dto);

    /**
     * 使用攻略移至
     * @param param
     * @return
     */
    Boolean move(StrategyMoveParam param);

    /**
     * 更新使用攻略展示状态
     * @param param
     * @return
     */
    Boolean updateShowStatue(StrategyShowStatusParam param);
}
