package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.params.seller.SellerCustomerEsParam;

import java.util.List;

/**
 * 销售客户es管理
 * @Author chentiecheng
 * @Date 2020/6/8 10:30 上午
 */
@AdvancedFeignClient
public interface RemoteSellerCustomerEsService {

    /**
     * 新增或修改es对象
     */
    void insertOrUpdate(List<Long> ids);

    /**
     * 根据客户标签查询客户用户id(谁看过我使用)
     * @param sellerId
     * @param sellerCustomerTagIds
     * @return
     */
    List<Long> searchByTagIds(Long sellerId, List<Long> sellerCustomerTagIds);

    /**
     * 根据变量查询客户id列表
     * @param sellerCustomerEsParam
     * @return
     */
    List<Long> searchByParam(SellerCustomerEsParam sellerCustomerEsParam);
}
