package cn.com.duiba.kjy.api.dto.crm;

import cn.com.duiba.kjy.api.enums.crm.CrmSellerCustomerProgressTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author linjianhui
 * @description 销售CRM客户更新跟进记录Dto
 * @date 2020/12/18 15:03
 */
@Data
public class CrmCustomerProgressRecordDto implements Serializable {

    private static final long serialVersionUID = 3161090232981058514L;
    /**
    * 主键
    */
    private Long id;

    /**
    * tb_crm_seller表主键ID
    */
    private Long crmSellerId;

    /**
    * 跟进进度类型:1初步沟通,2评估中,3确认合作,4PM介入,5确认排期,6首场上线,7完成复盘,10拒绝合作
     * @see CrmSellerCustomerProgressTypeEnum
    */
    private Integer progressType;

    /**
    * 备注
    */
    private String remark;

    /**
    * tb_crm_company表主键ID
    */
    private Long crmCompanyId;

    /**
    * tb_crm_seller_customer_abutment表主键ID
    */
    private Long crmCustomerAbutmentId;

    /**
    * 对接人名称
    */
    private String abutmentName;


    /**
     * 审核状态 1:审核中 2:已撤销 3:已通过 4:已拒绝
     */
    private Integer verifyState;

    /**
     * 直播场次
     */
    private Long liveNum;

    /**
     * 合作类型 1:新合作 2:长期合作
     */
    private Integer cooperateType;

    /**
     * 合作内容
     */
    private String cooperateContent;

    /**
     * 合作邮件
     */
    private String cooperateMail;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}

