package cn.com.duiba.kjy.api.dto.sellercustomerintention;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author wangbinbin
 * @create 2020-09-21 10:49
 * @descript 代理人意向度dto
 */
@Data
public class SellerCustomerIntentionDto implements Serializable {

    private static final long serialVersionUID = -7549355370751812784L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 代理人id,对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 客户的用户id,对应tb_user.id
     */
    private Long custUserId;

    /**
     * 客户id,对应tb_seller_customer.id
     */
    private Long sellerCustomerId;

    /**
     * 访问模块分数
     */
    private String visitModuleScore;

    /**
     * 阅读偏好模块分数
     */
    private String readModuleScore;

    /**
     * 互动模块分数
     */
    private String interactModuleScore;

    /**
     * 客户意向度
     */
    private Integer customerIntention;

    /**
     * 上次访问的时间
     */
    private Date lastVisitTime;

}
