package cn.com.duiba.kjy.api.enums.billing;

import lombok.Data;

import java.io.Serializable;

/**
* 代理人开单打卡奖励配置信息详情dto
*/
@Data
public class BillingClockAwardConfDetailDto implements Serializable {

    private static final long serialVersionUID = -6265194865897737277L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 奖励配置ID，tb_billing_clock_award_conf主键ID
     */
    private Long awardConfId;

    /**
     * 奖励图片地址
     */
    private String awardImg;

    /**
     * 奖励标题
     */
    private String awardTitle;

    /**
     * 奖励描述
     */
    private String awardDesc;

    /**
     * 奖励内容
     */
    private String awardContent;

    /**
     * 奖励类型：1vip会员 2券 3课程
     * @see BillingClockAwardTypeEnum
     */
    private Integer awardType;

}

