package cn.com.duiba.kjy.api.remoteservice.open;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.open.OpenUserDto;

/**
 * @author dugq
 * @date 2020/11/26 2:24 下午
 */
@AdvancedFeignClient
public interface RemoteOpenUserService {

    /**
     *根据id查询Entity
     *
     */
    OpenUserDto selectOne(Long id);

    /**
     * 绑定用户
     * @param id 第三方用户ID
     * @param userId 客集集userId
     * @param sellerId 客集集sellerId
     * @return 1：成功 0：失败
     */
    int bindUser(Long id, Long userId, Long sellerId);


    /**
     * 新增第三方用户
     */
    Long insert(OpenUserDto openUserDto);

    /**
     * 根据第三方公众号的oaID和用户ID查询第三方用户
     * @param oaId 第三方公众号公众号ID
     * @param userId 用户ID
     * @return 第三方用户
     */
    OpenUserDto selectByOaIdAndUserId(Long oaId, Long userId);

    /**
     * 根据第三方用户的公众号openID查询第三方用户
     */
    OpenUserDto selectByOpenId(String openId);
}
