package cn.com.duiba.kjy.api.remoteservice.crm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.crm.CrmCustomerProgressRecordDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.PageQuery;
import cn.com.duiba.kjy.api.params.crm.CrmCustomerProgressQryParam;
import cn.com.duiba.kjy.api.params.crm.CrmProgressQryParam;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 销售CRM客户更新跟进记录remote
 * @author zhanghuifeng
 * date 2020/12/4-14:41
 */
@AdvancedFeignClient
public interface RemoteCrmCustomerProgressRecordService {

    /**
     * 新增
     * @param dto
     * @return
     */
    Boolean save(CrmCustomerProgressRecordDto dto);

    /**
     * 新增返回id
     * @param dto
     * @return
     */
    Long saveV2(CrmCustomerProgressRecordDto dto);

    /**
     * 查询客户数
     * @param createStart 创建开始时间（包含）
     * @param createEnd 创建结束时间（包含）
     * @param crmSellerId crm销售ID
     * @param progressType 进度类型 {@link cn.com.duiba.kjy.api.enums.crm.CrmSellerCustomerProgressTypeEnum}
     * @return
     */
    int countCustomer(Date createStart, Date createEnd, Long crmSellerId, Integer progressType);

    /**
     * 根据公司ID查询跟进记录
     * @param crmCompanyId crm公司ID
     * @return 列表
     */
    List<CrmCustomerProgressRecordDto> findByCompanyId(Long crmCompanyId);

    /**
     * 根据参数查询跟进记录id列表
     * @param param
     * @return
     */
    List<Long> findIdsByParam(CrmProgressQryParam param);

    /**
     * 分页查询
     * @param param
     * @return
     */
    @Deprecated
    Page<CrmCustomerProgressRecordDto> pageList(CrmCustomerProgressQryParam param);

    /**
     * 分页查询
     * @param verifyState 审核状态
     * @param excludeProgressTypes 排除的跟进类型
     * @param pageQuery 分页参数
     * @return
     */
    Page<CrmCustomerProgressRecordDto> pageListByParam(Integer verifyState,List<Integer> excludeProgressTypes, PageQuery pageQuery);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    CrmCustomerProgressRecordDto findById(Long id);

    /**
     * 确认合作 审核记录条数 key：审核状态 value：条数
     * @return
     */
    Map<Integer,Integer> verifyStat();

    /**
     * 变更确认合作审核状态
     * @param progressId
     * @param verifyState
     * @return
     */
    Boolean updateVerifyState(Long progressId,Integer verifyState);

    /**
     * 根据参数查询客户数
     * @param param
     * @return
     */
    Integer countCustomerByParam(CrmCustomerProgressQryParam param);

    /**
     * 根据参数查询列表
     * @param param
     * @return
     */
    List<CrmCustomerProgressRecordDto> findByParam(CrmProgressQryParam param);

    /**
     * 根据参数查询总数
     * @param param
     * @return
     */
    int countByParam(CrmProgressQryParam param);

    /**
     * 根据param查询最新一条的记录
     * @param param
     * @return
     */
    CrmCustomerProgressRecordDto findLastRecordByParam(CrmProgressQryParam param);
}
