package cn.com.duiba.kjy.api.remoteservice.crm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.crm.CrmElectronicContractDto;

import java.util.List;

/**
 * @author linjianhui
 * @description 确认合作-合同审批信息
 * @date 2021/3/15 16:40
 */
@AdvancedFeignClient
public interface RemoteCrmElectronicContractService {

    /**
     * 新增合同审批
     * @param crmElectronicContractDto
     * @return
     */
    Long insert(CrmElectronicContractDto crmElectronicContractDto);

    /**
     * 更新合同审批
     * @param crmElectronicContractDto
     * @return
     */
    Integer update(CrmElectronicContractDto crmElectronicContractDto);

    /**
     * 根据跟进记录id查询合同审批信息
     * @param progressId 跟进记录id
     * @return
     */
    CrmElectronicContractDto findByProgressId(Long progressId);

    /**
     * 根据跟进记录id列表 批量查询合同审批信息
     * @param progressIds 跟进记录id列表
     * @return
     */
    List<CrmElectronicContractDto> findByProgressIds(List<Long> progressIds);
}
