package cn.com.duiba.kjy.api.remoteservice.guess;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.guess.GuessQuesContentClueDto;

/**
 * 猜你所想文章线索
 * @author 吴文哲
 * @date 2021/4/30 2:02 下午
 **/
@AdvancedFeignClient
public interface RemoteGuessQuesContentClueService {

    /**
     * 保存线索
     * @param guessQuesContentClueDto 猜你所想文章线索详情
     * @return 影响行数
     */
    Integer saveClue(GuessQuesContentClueDto guessQuesContentClueDto);

    /**
     * 根据代理人id + 用户id 查询线索详情
     * @param sellerId 代理人id
     * @param userId 访客用户id
     * @return 猜你所想线索详情
     */
    GuessQuesContentClueDto findBySellerIdAndUserId(Long sellerId,Long userId);

}
