package cn.com.duiba.kjy.api.remoteservice.guide;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.useHelpTips.UseHelpTipsDto;
import cn.com.duiba.kjy.api.params.guide.UseHelpTipsParam;

import java.util.List;

/**
 * 使用帮助Tips管理
 * @Author chentiecheng
 * @Date 2020/6/1 4:02 下午
 */
@AdvancedFeignClient
public interface RemoteUseHelpTipsService {

    /**
     * 新增编辑使用帮助Tips
     * @param dto
     * @return
     */
    Boolean addOrUpdateTips(UseHelpTipsDto dto);

    /**
     * 使用帮助Tips列表查询
     * @param param
     * @return
     */
    List<UseHelpTipsDto> getListByParam(UseHelpTipsParam param);

    /**
     * 使用帮助Tips总数查询
     * @param param
     * @return
     */
    Long countByParam(UseHelpTipsParam param);

    /**
     * 根据id删除Tips
     * @param id
     * @return
     */
    Boolean deleteById(Long id);
}
