package cn.com.duiba.kjy.api.params.animation;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;


/**
 * @author lizhi
 * @date 2019/8/23 11:33 AM
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class AnimationMaterialParams extends PageQuery {

    private static final long serialVersionUID = -7938405655087350462L;

    /**
     * 素材名称
     */
    private String materialName;

    /**
     * 分类主键
     */
    private Long categoryId;

    /**
     * 素材类型（图片、音乐等），由前端定义值，后端只存储
     */
    private Integer materialType;

    /**
     * 权限范围（用户、系统等），由前端定义值，后端只存储
     */
    private Integer scope;
}
