package cn.com.duiba.kjy.api.remoteservice.sms.signature;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.sms.SmsSignatureDto;

import java.util.List;

/**
 * @author gxy
 * @date 2021/5/27 12:01 下午
 */
@AdvancedFeignClient
public interface RemoteSignatureService {
    /**
     * 查询所有的短信签名
     * @return 全部的签名列表
     */
    List<SmsSignatureDto> selectSmsSignatureList();

    /**
     * 删除短信签名，软删
     * @param id 主键
     * @return 删除结果
     */
    Boolean delSmsSignature(Long id);

    /**
     * 新增
     * @param smsSignatureDto 对象
     * @return 新增结果
     */
    Integer save(SmsSignatureDto smsSignatureDto);

    /**
     * 修改
     * @param smsSignatureDto 对象
     * @return 修改结果
     */
    Integer update(SmsSignatureDto smsSignatureDto);

    /**
     * 根据ids批量查询
     * @param list ids
     * @return 查询结果
     */
    List<SmsSignatureDto> selectSignatureByIds(List<Long> list);

    /**
     * 根据ID查询
     * @param id 主键
     * @return 查询结果
     */
    SmsSignatureDto selectById(Long id);
}
