package cn.com.duiba.kjy.api.enums.dailyPosters;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author linjianhui
 * @description 图库分类
 * @date 2020/11/13 14:08
 */
public enum GalleryClassifyEnum {

    /**
     * 早安图库
     */
    NATURE(1, GalleryTypeEnum.GOOD_MORNING,"自然"),
    LIFE(2, GalleryTypeEnum.GOOD_MORNING,"生活"),
    EXERCISE(3, GalleryTypeEnum.GOOD_MORNING,"运动"),
    TINY_ANIMAL(4, GalleryTypeEnum.GOOD_MORNING,"小动物"),
    ILLUSTRATION(5, GalleryTypeEnum.GOOD_MORNING,"插画"),

    /**
     * 晚安图库
     */
    TOWARD_EVENING(6, GalleryTypeEnum.GOOD_NIGHT,"傍晚"),
    SLEEPLESS_CITY(7, GalleryTypeEnum.GOOD_NIGHT,"夜都市"),
    STARRY_NIGHT(8, GalleryTypeEnum.GOOD_NIGHT,"星月"),
    LIGHT(9, GalleryTypeEnum.GOOD_NIGHT,"灯光"),
    NIGHT_ILLUSTRATION(10, GalleryTypeEnum.GOOD_NIGHT,"插画"),
    ;

    private Integer code;

    private GalleryTypeEnum typeEnum;

    private String desc;

    GalleryClassifyEnum(Integer code,GalleryTypeEnum typeEnum, String desc) {
        this.code = code;
        this.typeEnum = typeEnum;
        this.desc = desc;
    }

    private static final Map<Integer, GalleryClassifyEnum> ENUM_MAP = new HashMap<>();

    static{
        for(GalleryClassifyEnum classifyEnum : values()){
            ENUM_MAP.put(classifyEnum.getCode(), classifyEnum);
        }
    }

    public static GalleryClassifyEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    /**
     * 根据类型获取对应分类
     * @param typeEnum
     * @return
     */
    public static List<Integer> getGameActivityContentTypes(GalleryTypeEnum typeEnum) {
        List<Integer> codeList = new ArrayList<>();
        for (GalleryClassifyEnum classifyEnum : values()) {
            if (Objects.equals(classifyEnum.typeEnum.getCode(),typeEnum.getCode())) {
                codeList.add(classifyEnum.code);
            }
        }
        return codeList;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
