package cn.com.duiba.kjy.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.activity.ActivityConfLotteryDto;
import cn.com.duiba.kjy.api.dto.activity.SellerActivityConfDto;
import cn.com.duiba.kjy.api.dto.activity.detail.SellerActivityConfDetailDto;
import cn.com.duiba.kjy.api.params.activity.SellerActivityConfParams;

import java.util.List;
import java.util.Map;

/**
 * 活动配置-抽奖游戏库类型
 * @author lizhi
 * @date 2019/10/24 4:53 PM
 */
@AdvancedFeignClient
public interface RemoteActivityConfLotteryService {

    /**
     * 新增活动配置
     * @param dto 参数
     * @return 活动配置主键
     */
    @Deprecated
    Long save(ActivityConfLotteryDto dto);

    /**
     * 新增或更新配置
     * @param detailDto 配置详细信息
     * @return 配置主键
     */
    Long saveOrUpdateConf(SellerActivityConfDetailDto detailDto);

    /**
     * 根据配置ID，查询配置详情（包含奖品及中奖人信息）
     * @param activityConfId 配置ID
     * @return 配置详情
     */
    SellerActivityConfDetailDto findByActivityConfIdCache(Long activityConfId);

    /**
     * 分页查询
     * @param params 分页参数
     * @return 列表
     */
    List<SellerActivityConfDto> findPage(SellerActivityConfParams params);

    /**
     * 修改分享海报小程序码
     * @param id 主键
     * @param posterMpQrCode 小程序码
     * @return 执行结果
     */
    int updatePosterMpQrCode(Long id, String posterMpQrCode);

    /**
     * 根据主键查询小程序码
     * @param id 主键
     * @return 分享海报小程序码
     */
    String getPosterMpQrCodeById(Long id);

    /**
     * 获取每个活动分享次数
     * @param activityIds 活动ID
     * @return key：activityId，value：分享数量
     */
    Map<Long, Long> getActivityConfCountMap(List<Long> activityIds);
}
