package cn.com.duiba.kjy.api.remoteservice.aivideo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.aivideo.AiVideoRecordDto;
import cn.com.duiba.kjy.api.params.PageQuery;
import cn.com.duiba.kjy.api.params.aivideo.AiVideoRecordParam;

import java.util.List;

/**
 * 代理人AI跟拍视频记录表 Service
 *
 * @author chentiecheng
 * 2021-4-26 16:23:49
 */
@AdvancedFeignClient
public interface RemoteAiVideoRecordService {
    /**
     * 新增记录
     *
     * @param dto 视频记录
     * @return 执行结果
     */
    int save(AiVideoRecordDto dto);

    /**
     * 更新状态
     *
     * @param videoStatus 视频状态 {@link cn.com.duiba.kjy.api.enums.aivideo.AiVideoStatusEnum}
     * @param streamId    流id
     * @return 执行结果
     */
    int updateStatusByStreamId(Integer videoStatus, Long streamId);

    /**
     * 开始录制
     *
     * @param streamId 流id
     * @return 执行结果
     */
    int startByStreamId(Long streamId);

    /**
     * 根据id更新
     *
     * @param dto 视频记录
     * @return 执行结果
     */
    int updateById(AiVideoRecordDto dto);

    /**
     * 根据id获取
     *
     * @param streamId 主键id
     * @return 视频记录
     */
    AiVideoRecordDto selectByStreamId(Long streamId);

    /**
     * 根据userId查询未结束视频记录
     *
     * @param userId 用户id
     * @return 视频记录
     */
    AiVideoRecordDto selectNotEndVideoRecord(Long userId);

    /**
     * 分页查询列表信息，仅查询状态=5的数据(有视频的数据)
     *
     * @param params 分页数据
     * @return 列表信息
     */
    List<AiVideoRecordDto> selectPage(AiVideoRecordParam params);

    /**
     * 统计状态为5的
     * @param params 数据
     * @return 数量
     */
    long selectCount(AiVideoRecordParam params);
}
