package cn.com.duiba.kjy.api.remoteservice.nps;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.nps.SellerNpsRecordDto;

/**
 * nps提交记录
 *
 * @author xuzhigang
 * @date 2021/7/6 5:25 下午
 **/
@AdvancedFeignClient
public interface RemoteSellerNpsRecordService {
    /**
     * 根据代理人id和nps配置id查询nps提交记录
     *
     * @param sellerId 代理人id
     * @param confId nps配置id
     * @return nps提交记录
     */
    SellerNpsRecordDto selectBySellerIdAndConfId(Long sellerId, Long confId);

    /**
     * 保存nps提交记录
     *
     * @param entity 提交记录
     * @return 保存结果
     */
    int insert(SellerNpsRecordDto entity);
}
