package cn.com.duiba.kjy.api.enums.explosioncontent;

import lombok.Getter;

/**
 * faq位置枚举
 * @author xiaotian
 * @date 2020-07-13 17:57
 **/
@Getter
public enum LocationSourceEnum {

    ARTICLE(1,"文章"),
    COLUMN(2,"个人专栏"),

    ;
    private Integer code;
    private String desc;

    LocationSourceEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static LocationSourceEnum getByCode(Integer code){
        for (LocationSourceEnum locationSourceEnum : LocationSourceEnum.values()){
            if(locationSourceEnum.getCode().equals(code)){
                return locationSourceEnum;
            }
        }
        //默认文章
        return ARTICLE;
    }

}
