package cn.com.duiba.kjy.api.params.seller;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @auther: linjianhui
 * @date: 2020-04-29 16:12
 * @description: 查询代理人动态流水信息参数
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SellerDynamicSearchParams extends PageQuery {

    /**
     * 销售id
     */
    Long sellerId;

    /**
     * {@link cn.com.duiba.kjy.api.enums.seller.SellerDynamicTypeEnum}
     */
    Integer dynamicType;

    /**
     * 上一页最小主键id
     */
    Long lastMinId;

    /**
     * 记录开始时间
     */
    private Date startTime;

    /**
     * 记录结束时间
     */
    private Date endTime;
}
