package cn.com.duiba.kjy.api.dto.company;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 公司动态关联表
 * @author kjj mybatis generator 
 * 2019-12-28
 */
@Data
public class CompanyNewsDto implements Serializable {
    private static final long serialVersionUID = 15775125098047316L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *公司id
     * not null default = null
     */
    private Long companyId;

    /**
     *
     *公司等级 1:分公司 2:总公司
     * not null default = null
     */
    private Integer companyLevel;

    /**
     *
     *公司动态内容id
     * not null default = null
     */
    private Long contentId;

    /**
     *
     *记录类型：article =文章
     * max length = 48
     * not null default = 
     */
    private String contentType;

    /**
     *
     *事件时间
     * not null default = null
     */
    private Date eventDate;

    /**
     *
     *排序
     * not null default = null
     */
    private Integer sort;

    /**
     *
     *状态 1:待发布 2:已发布 3:已删除
     * not null default = null
     */
    private Integer state;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}