package cn.com.duiba.kjy.api.enums.seller;

import java.util.HashMap;
import java.util.Map;

/**
 * 客集集代理人领奖记录业务类型
 * @author zhanghuifeng
 * date 2020/11/20-17:38
 */
public enum SellerDrawAwardBizTypeEnum {

    BILLING_CLOCK(1, "60天开单打卡奖励"),

    ;

    private Integer code;
    private String desc;

    SellerDrawAwardBizTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, SellerDrawAwardBizTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(SellerDrawAwardBizTypeEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static SellerDrawAwardBizTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
