package cn.com.duiba.kjy.api.constant;

import cn.com.duiba.kjy.api.enums.seller.SellerFromEnum;

import java.util.Objects;

/**
 * @auther: linjianhui
 * @date: 2019-10-16 17:32
 * @description: 销售来源与客集集来源映射
 */
public enum SellerAccessSourceEnum {
    /**
     * 一般途径：包含关注、扫码关注、扫码事件（已关注）
     */
    NORMAL_SUBSCRIBE(SellerFromEnum.NORMAL,47,"一般途径"),

    PRIVATE_CHAT(SellerFromEnum.PRIVATE_CHAT,15,"私信页面-聊天界面"),

    INVITE_FRIEND(SellerFromEnum.POSTER_INVITE,22,"分享付费会员开通页面，邀请好友"),

    CHANGE_CARD(SellerFromEnum.CARD,48,"换成我的，文章、午报、晚报换名片邀请"),

    SITE_SALE_QR(SellerFromEnum.SITE_SALE_QR,49,"会销邀请"),

    OUR_INSIDE_RECOMMEND(SellerFromEnum.OUR_INSIDE_RECOMMEND,50,"公司内部销售推荐"),

    WEEKLY_PUBLICATION(SellerFromEnum.WEEKLY_PUBLICATION,51,"周报中关注客集集"),

    NOVICE_TASK(SellerFromEnum.NOVICE_TASK,52,"新手任务邀请"),

    ACTIVATE_CODE(SellerFromEnum.ACTIVATE_CODE,45,"激活码"),

    WX_MP_BASE_AUTH(SellerFromEnum.WX_MP_BASE_AUTH,46,"小程序授权"),

    PC_OFFICIAL_WEBSITE(SellerFromEnum.PC_OFFICIAL_WEBSITE,77,"官网"),

    WX_FISSION_MP_BSE_AUTH(SellerFromEnum.WX_FISSION_MP_BSE_AUTH, 80, "微信裂变小程序授权"),

    WX_GAME_MP_BASE_AUTH(SellerFromEnum.WX_GAME_MP_BASE_AUTH, 110, "抽奖工具小程序授权"),

    WX_GREETING_MP_BASE_AUTH(SellerFromEnum.WX_GREETING_MP_BASE_AUTH, 111, "节日贺卡小程序授权"),

    DAILY_CHANGE_CARD(SellerFromEnum.DAILY_CHANGE_CARD,126,"换成我的,早报换名片邀请"),

    VIDEO_CHANGE_CARD(SellerFromEnum.VIDEO_CHANGE_CARD,137,"换成我的,视频换名片邀请"),

    CARTOON_CHANGE_CARD(SellerFromEnum.CARTOON_CHANGE_CARD,127,"换成我的,动画换名片邀请"),

    GAME_ANSWER_CHANGE_CARD(SellerFromEnum.GAME_ANSWER_CHANGE_CARD,135,"换成我的,小游戏换名片邀请"),

    GAME_LOTTERY_CHANGE_CARD(SellerFromEnum.GAME_LOTTERY_CHANGE_CARD,136,"换成我的,抽奖工具换名片邀请"),

    OTHER_CHANGE_CARD(SellerFromEnum.OTHER_CHANGE_CARD,134,"换成我的,其他内容页换名片邀请"),

    DAILY_CHANGE_DAILY_MYPOINT(SellerFromEnum.DAILY_CHANGE_MYPOINT,143,"早报换我的观点(换成我的观点弹层)"),

    PRE_INSTALL(SellerFromEnum.PRE_INSTALL,159,"会员预设"),

    OPEN_USER(SellerFromEnum.OPEN_USER,190,"第三方公众号用户"),

    LIVE_VISITOR_MAP_COMPANY_NAME_LIST(SellerFromEnum.LIVE_VISITOR_MAP_COMPANY_NAME_LIST,194,"直播访客匹配架构名单成为代理人"),
    ;

    /**
     * 销售来源定义
     */
    private SellerFromEnum sellerFromEnum;

    /**
     * 客集集来源
     */
    private Integer accessSource;

    /**
     * 描述
     */
    private String desc;

    SellerAccessSourceEnum(SellerFromEnum sellerFromEnum,Integer accessSource, String desc) {
        this.sellerFromEnum = sellerFromEnum;
        this.accessSource = accessSource;
        this.desc = desc;
    }

    public static SellerAccessSourceEnum getBySellerFromEnum(SellerFromEnum sellerFromEnum){
        if (Objects.isNull(sellerFromEnum)){
            return null;
        }
        for (SellerAccessSourceEnum sellerAccessSourceEnum:values()){
            if (sellerAccessSourceEnum.getSellerFromEnum().equals(sellerFromEnum)){
                return sellerAccessSourceEnum;
            }
        }
        return null;
    }

    public SellerFromEnum getSellerFromEnum() {
        return sellerFromEnum;
    }

    public Integer getAccessSource() {
        return accessSource;
    }

    public String getDesc() {
        return desc;
    }}
