package cn.com.duiba.kjy.api.dto.billing;

import cn.com.duiba.kjy.api.enums.billing.BillingPlanDateTypeEnum;
import lombok.Data;

import java.io.Serializable;


/**
* 代理人开单计划每天或每周任务状态表
*/
@Data
public class BillingPlanStateDto implements Serializable {

    private static final long serialVersionUID = 4016692519744248601L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 代理人ID
    */
    private Long sellerId;

    /**
    * 状态 1:进行中 2:完成 3:失败 4:发起退款 5:失败体验
    */
    private Integer taskStatus;

    /**
    * 第几天/周
    */
    private Integer dateFlag;

    /**
    * 日期类型：1:日，2:周
     * @see BillingPlanDateTypeEnum
    */
    private Integer dateType;

}

