package cn.com.duiba.kjy.api.remoteservice.billing;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.billing.BillingClockTaskDto;

import java.util.List;

/**
 * 60天开单打卡remote
 * @author zhanghuifeng
 * date 2020/11/17-16:22
 */
@AdvancedFeignClient
public interface RemoteBillingClockTaskService {

    /**
     * 根据代理人ID和任务类型查询数量
     * @param sellerId 代理人ID
     * @param taskType 任务类型 {@link cn.com.duiba.kjy.api.enums.billing.BillingClockTaskTypeEnum}
     * @param needFinishDay 任务需要在哪天完成
     * @return 数量
     */
    int countBySellerAndType(Long sellerId,Integer needFinishDay, Integer taskType);

    /**
     * 根据代理人ID和任务类型查询
     * @param sellerId 代理人ID
     * @param taskType 任务类型 {@link cn.com.duiba.kjy.api.enums.billing.BillingClockTaskTypeEnum}
     * @param needFinishDay 任务需要在哪天完成
     * @return 信息
     */
    BillingClockTaskDto findBySellerAndType(Long sellerId,Integer needFinishDay, Integer taskType);

    /**
     * 根据代理人开单打卡每天任务状态表主键ID查询
     * @param dayStateId 代理人开单打卡每天任务状态表主键ID
     * @return 任务列表
     */
    List<BillingClockTaskDto> findByDayStateId(Long dayStateId);

    /**
     * 根据代理人ID和任务类型查询数量
     * @param sellerId 代理人ID
     * @param needFinishDay 任务需要在哪天完成
     * @return 任务列表
     */
    List<BillingClockTaskDto> findBySellerAndNeedFinishDay(Long sellerId, Integer needFinishDay);

    /**
     * 完成任务流程
     * @param sellerId 代理人ID
     * @param taskType 任务类型 {@link cn.com.duiba.kjy.api.enums.billing.BillingClockTaskTypeEnum}
     */
    void finishTask(Long sellerId, Integer taskType, Long bizId);

}
