package cn.com.duiba.kjy.api.dto.push;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 访客线索推送任务
 * @author kjj mybatis generator 
 * 2021-04-14
 */
@Data
public class VisitorMaterialPushTaskDto implements Serializable {

    private static final long serialVersionUID = 16183667674601829L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 销售员id
     */
    private Long sellerId;

    /**
     * 推送阶段，存的10进制的数字，与枚举的code对应，为1表示推送过了
     * @see cn.com.duiba.kjy.api.enums.push.VisitorMaterialPushStageEnum
     */
    private Integer pushStage;

    /**
     * 推送状态，0：无需推送 1：正常
     * @see cn.com.duiba.kjy.api.enums.BooleanEnum
     */
    private Integer pushState;

    /**
     * 客服消息
     */
    private String customerText;

    /**
     * 客服模板消息
     */
    private String customerTemplate;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

}