package cn.com.duiba.kjy.api.enums.content;

import cn.com.duiba.kjy.api.util.IdMakerUtil;
import com.google.common.collect.ImmutableMap;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang.StringUtils;

/**
 * 内容推送回复枚举
 *
 * @author xuzhigang
 * @date 2021/7/2 1:51 下午
 **/
@Getter
@AllArgsConstructor
public enum ContentPushReplyEnum {
    DAILY_CONTENT("ZB", "早报"),

    EVENING_GREETING("WX", "晚安心语"),
    
    GRASS_CONTENT("ZC", "种草素材"),
    
    HOT_CONTENT("RW", "热文"),
    ;

    /**
     * 自动回复前缀
     */
    private final String replyPrefix;

    /**
     * 描述
     */
    private final String desc;

    private static final ImmutableMap<String, ContentPushReplyEnum> map = ImmutableMap.<String, ContentPushReplyEnum>builder()
            .put(DAILY_CONTENT.replyPrefix, DAILY_CONTENT)
            .put(EVENING_GREETING.replyPrefix, EVENING_GREETING)
            .put(GRASS_CONTENT.replyPrefix, GRASS_CONTENT)
            .put(HOT_CONTENT.replyPrefix, HOT_CONTENT)
            .build();

    public static ContentPushReplyEnum getEnumByReplyPrefix(String replyPrefix) {
        if (StringUtils.isBlank(replyPrefix)) {
            return null;
        }
        return map.get(replyPrefix);
    }

    /**
     * 根据文章id和内容获取回复链接
     */
    public String getReplyLink(Long contentId, String msg, int index) {
        String replyMsg = StringUtils.join(new String[]{this.getReplyPrefix(), IdMakerUtil.encodingIdByBase64(contentId), String.valueOf(index)}, "_");
        return "<a href='weixin://bizmsgmenu?msgmenucontent=" + replyMsg + "&msgmenuid=0'>" + msg + "</a>";
    }

}
