package cn.com.duiba.kjy.api.enums.crm;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 客户意向主题枚举
 */
public enum CrmCustumerIntentionEnum {

    /**
     * 意向主题
     */
    STRANGE_VISIT("1", "业务"),
    RECOMMEND("2", "增员")
    ;


    private final String code;
    private final String desc;

    CrmCustumerIntentionEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<String, CrmCustumerIntentionEnum> ENUM_MAP = new HashMap<>();

    static {
        for (CrmCustumerIntentionEnum item : CrmCustumerIntentionEnum.values()) {
            ENUM_MAP.put(item.getCode(), item);
        }
    }

    public static CrmCustumerIntentionEnum getByCode(String code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public static Boolean containsCode(String code) {
        return Objects.nonNull(ENUM_MAP.get(code));
    }

}
